<?php
// 后台登录凭证
$admin_credentials = array (
  'username' => 'admin',
  'password' => '123456',
);

// 前台配置
$site_config = array (
  'site_title' => '刀客源码导航',
  'site_desc' => '让网络访问更轻松便捷',
  'avatar_url' => 'data:image/png;base64,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',
  'background_type' => 'none',
  'background_color1' => '#00ffff',
  'background_color2' => '#ffffff',
  'announcement' => 
  array (
    'title' => '重要公告',
    'content' => 
    array (
      0 => '导航页面已完成全面优化！',
      1 => '应用图标已重新设计，视觉效果提升',
      2 => '「免费去插播」服务持续优化中',
      3 => '瓜子采集+解析稳定速度快推荐购买！',
    ),
  ),
  'apps' => 
  array (
    0 => 
    array (
      'name' => '免费去插播',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--danger-color),var(--warning-color))',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M12 3v9.28c-.47-.17-.97-.28-1.5-.28C8.01 12 6 14.01 6 16.5S8.01 21 10.5 21c2.31 0 4.2-1.75 4.45-4H15V6h4V3h-7z"/></svg>',
    ),
    1 => 
    array (
      'name' => '收费去插播',
      'url' => 'https://www.dkewl.com/',
      'icon_bg' => 'linear-gradient(135deg,var(--accent-color),#341f97)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/></svg>',
    ),
    2 => 
    array (
      'name' => '刀客源码网',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--success-color),#0c9670)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2zM22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/></svg>',
    ),
    3 => 
    array (
      'name' => '网站源码',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--accent-color),#2a1769)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><path d="M1 10h22"/></svg>',
    ),
    4 => 
    array (
      'name' => '更多资源',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--warning-color),#f39c12)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><circle cx="12" cy="12" r="10"></circle><path d="M16 8s-1.5 2-4 2-4-2-4-2"/></svg>',
    ),
    5 => 
    array (
      'name' => '插播资源站',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--primary-color),#1e68b0)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><path d="M21 15l-5-5-5 5"></path></svg>',
    ),
    6 => 
    array (
      'name' => '免费官采',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,#54a0ff,var(--primary-dark))',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path><path d="M7.5 4.21l4.5 2.6 4.5-2.6"></path><path d="M7.5 19.79V14.6L3 12"></path><path d="M21 12l-4.5 2.6v5.19"></path><path d="M3.27 6.96L12 12.01l8.73-5.05"></path><path d="M12 22.08V12"></path></svg>',
    ),
    7 => 
    array (
      'name' => 'SK反编译',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--accent-color),#3b2083)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"></path></svg>',
    ),
    8 => 
    array (
      'name' => '小姐姐',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--secondary-color),#ff6b8f)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><circle cx="12" cy="8" r="4"></circle><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path></svg>',
    ),
    9 => 
    array (
      'name' => '加入Q群',
      'url' => 'https://www.dkewl.com',
      'icon_bg' => 'linear-gradient(135deg,var(--primary-light),#00a8e0)',
      'icon_svg' => '<svg viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="1.5"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>',
    ),
  ),
  'footer_links' => 
  array (
    0 => 
    array (
      'text' => '关于我们',
      'url' => '#',
    ),
    1 => 
    array (
      'text' => '帮助中心',
      'url' => '#',
    ),
    2 => 
    array (
      'text' => '意见反馈',
      'url' => '#',
    ),
    3 => 
    array (
      'text' => '服务条款',
      'url' => '#',
    ),
  ),
  'copyright' => '2025 刀客导航 | 简约 · 高效 · 实用',
);
?>